<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
class CategoryController extends Controller
{   

     public function __construct()
    {
        $this->middleware('auth_check');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
          $categories = DB::table('categories')->orderBy('id','DESC')->paginate(10);
          return view('category.index', compact('categories'));
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('category.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {    
        try{    
                $request->validate([
                   'title' => 'required|string|unique:categories',
                   'image' => 'required',
                 ]);
                $file = $request->file('image');
                $name = time().$file->getClientOriginalName();
                $file->move(public_path().'/uploads/categories/', $name);  
                $path= 'uploads/categories/'.$name; 
                $data = array();
                $data['title'] = $request->title;
                $data['image'] = $path;
                DB::table('categories')->insert($data);
                $notification=array(
                         'messege'=>'Successfully Category Added',
                         'alert-type'=>'success'
                        );
                return redirect()->back()->with($notification);

        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try{
          $category = DB::table('categories')->where('id',$id)->first();
          return view('category.edit', compact('category'));
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try{
          $category = DB::table('categories')->where('id',$id)->first();
          return view('category.edit', compact('category'));
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
          $category = DB::table('categories')->where('id',$id)->first();
              $request->validate([
               'title' => 'required|string|unique:categories,title,'.$id,
               'image' => 'required'
              ]);
           if($request->file('image'))
           {
                $file = $request->file('image');
                $name = time().$file->getClientOriginalName();
                $file->move(public_path().'/uploads/categories/', $name);  
                $path= 'uploads/categories/'.$name; 
                unlink($category->image);
           }
           else
           {
              $path = $category->image;
           }
            $data = array();
            $data['title'] = $request->title;
            $data['image'] = $path;
            DB::table('categories')->where('id',$id)->update($data);
            $notification=array(
                         'messege'=>'Successfully Category Updated',
                         'alert-type'=>'success'
                        );
                return redirect()->back()->with($notification);
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
          $category = DB::table('categories')->where('id',$id)->first();
          unlink($category->image);
          DB::table('categories')->where('id',$id)->delete();
          return response()->json('deleted');
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function categoryPaginate(Request $request)
    {
        try{
          if(empty($request->title))
          {
            $categories = DB::table('categories')->orderBy('id','DESC')->paginate(10);
          }
          else
          {
            $categories = DB::table('categories')->where('title', 'like', "%$request->title%")->orderBy('id','DESC')->paginate(10);
          }
          
          return view('category.paginate', compact('categories')); 
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function searchCategory(Request $request)
    {
        try{
          $categories = DB::table('categories')->where('title', 'like', "%$request->title%")->orderBy('id','DESC')->paginate(10);
          return view('category.paginate', compact('categories')); 
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
}
