<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Auth;
use Hash;
use App\Models\User;
class SettingController extends Controller
{   

    public function __construct()
    {
        $this->middleware('auth_check');
    }
    
    public function changePassword()
    {
    	return view('change_password');
    }

    public function passwordUpdate(Request $request)
    {
    	$request->validate([
                 'old_password' => 'required|string',
                 'new_password' => 'required|string',
                 'confirm_password' => 'required|string',
         ]);

    	if(!Hash::check($request->old_password, auth()->user()->password)){
              $notification=array(
                         'messege'=>'Old password is not matched',
                         'alert-type'=>'error'
                        );
                return redirect()->back()->with($notification);
        }

        if($request->new_password != $request->confirm_password)
        {
        	$notification=array(
                         'messege'=>'New password and Confirm password are not matched',
                         'alert-type'=>'error'
                        );
                return redirect()->back()->with($notification);
        }

        User::whereId(auth()->user()->id)->update([
                'password' => Hash::make($request->new_password)
            ]);


        $notification=array(
                         'messege'=>'Successfully password change',
                         'alert-type'=>'success'
                        );
                return redirect()->back()->with($notification);
    }
}
