@extends('admin_master')
@section('content')
 
 <div class="content-wrapper">
   <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>News</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Simple Tables</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <section class="content">
    	<div class="container-fluid">
          <div class="row">
            <div class="col-md-12">
            	<div class="card">
              <div class="card-header">
                <h3 class="card-title">News Lists</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
              	<div class="conts">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th style="text-align: center;">Image</th>
                      <th style="text-align: center;">Title</th>
                      <th style="text-align: center;">Action</th>
                    </tr>
                  </thead>
                  <tbody>
                  	@foreach($blogs as $row)
                    <tr id="blog_{{$row->id}}">
                    	<td style="text-align: center;">
                    	  <img src="{{URL::to('public/'.$row->image)}}" style="width: 60px; height: 60px;">
                    	</td>
                      <td style="text-align: center;">{{$row->title}}</td>
                      <td style="text-align: center;">
                      	<a href="{{route('blogs.edit',$row->id)}}" class="btn btn-info btn-sm">Edit</a>
                      	<a style="color: white; cursor: pointer;" class="btn btn-danger btn-sm delete-blog" data-id="{{$row->id}}">Delete</a>
                      </td>
                    </tr>
                    @endforeach
                  </tbody>
                </table>
               </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
            </div>
          </div>
    	</div>
    </section>
 </div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function(){

  	$.ajaxSetup({
	    headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	    }
	});
    
    $(document).on('click', '.delete-blog', function(e){
    	e.preventDefault();
    	if(confirm('Do you want to delete this?'))
    	{
    		var id = $(this).data('id');
  			$('#blog_'+id).remove();
	  		$.ajax({
	             url: "{{  url('/blogs') }}/"+id,

	             type:"DELETE",
	             dataType:"json",
	             success:function(data) {
	                 toastr.success('Successfully Blog Deleted')
	             },
	                    
	        });
    	}
    });
  	

  });
</script>
@endsection