@extends('admin_master')
@section('content')
 <div class="content-wrapper">
    <section class="content-header"> 
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>General Form</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">General Form</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12">
             <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Update FAQ</h3>
              </div>

              @if (count($errors) > 0)
               <div class = "alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
            @endif
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{route('faqs.update',$faq->id)}}" enctype="multipart/form-data" method="post">
                @csrf
                @method('PATCH')
                <div class="card-body">
                  
                  <div class="form-group">
                    <label for="title">Title</label>
                    <input type="text" name="title" class="form-control" id="title" placeholder="Title" required="" value="{{$faq->title}}">
                  </div> 


                  <div class="col-md-12">
                     <div class="form-group">
                      <label for="description">Description</label>
                       <textarea class="ckeditor form-control" name="description" required="">{!!$faq->description!!}</textarea>
                     </div>
                   </div>

                  
                </div>
                <!-- /.card-body -->

                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Update FAQ</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
 </div>

 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
 <script>
    
    $.ajaxSetup({
      headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
  });

  CKEDITOR.replace('description', {
        filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",
        filebrowserUploadMethod: 'form'
    });

  function readURL(input) {
      if (input.files && input.files[0]) {
        $('#image').css('display', 'block');
          var reader = new FileReader();
          reader.onload = function (e) {
              $('#image')
                  .attr('src', e.target.result)
                  .width(60)
                  .height(60);
          };
          reader.readAsDataURL(input.files[0]);
      }
   }

 </script>
@endsection