@extends('admin_master')
@section('content')
 
 <div class="content-wrapper">
   <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Order Lists</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Simple Tables</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <section class="content">
    	<div class="container-fluid">
          <div class="row">
            <div class="col-md-12">
            	<div class="card">
              <div class="card-header">
                <h3 class="card-title">Total Booking Price: {{$total}} BDT</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
              	<div class="conts">
                 <div class="row" style="margin-bottom: 10px;">
                   <div class="col-md-3">
                   	<label for="start_date">From Date</label>
                  	<input  type="date" name="start_date" id="start_date" class="form-control start_date" placeholder="From Date">
                  </div>
                  
                  <div class="col-md-3">
                  	<label for="start_date">To Date</label>
                  	<input  type="date" name="end_date" id="end_date" class="form-control end_date" placeholder="To Date">
                  </div>

                  <div class="col-md-3">
                    <label for="status">Status</label>
                    <select class="form-control status" id="status">
                      <option value="all">All</option>
                      <option value="pending">Pending</option>
                      <option value="success">Success</option>
                    </select>
                  </div>

                  <div class="col-md-3">
                  	 <button style="margin-top: 30px;" type="button" class="btn btn-primary fliter_booking">Search Booking</button>
                  </div>

                 </div>
                 <div class="conts_section">
                 	<img style="display: none;" class="center-block" src="{{asset('back/loader.gif')}}">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th style="text-align: center;">Date</th>
                      <th style="text-align: center;">Customer Name</th>
                      <th style="text-align: center;">Customer Phone</th>
                      <th style="text-align: center;">Product Name</th>
                      <th style="text-align: center;">Product Price</th>
                      <th style="text-align: center;">Quantity</th>
                      <th style="text-align: center;">Unit Total</th>
                      <th style="text-align: center;">Status</th>
                    </tr>
                  </thead>
                  <tbody>
                  	@foreach($orders as $key=>$row)
                    <tr id="order_{{$row->id}}">
                      <td style="text-align: center;">{{$row->date}}</td>
                      <td style="text-align: center;">{{$row->name}}</td>
                      <td style="text-align: center;">{{$row->phone}}</td>
                      <td style="text-align: center;">{{$row->product_name}}</td>
                      <td style="text-align: center;">{{$row->product_price}} BDT</td>
                      <td style="text-align: center;">{{$row->cart_qty}}</td>
                      <td style="text-align: center;">{{$row->cart_total}}</td>
                      <td style="text-align: center;">
                       {{$row->status}}
                      </td>
                    </tr>
                    @endforeach
                  </tbody>
                </table>
                {{$orders->links()}}
                </div>
               </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
            </div>
          </div>
    	</div>
    </section>
 </div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function(){

  	$.ajaxSetup({
	    headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	    }
	});
    
    $(document).on('click', '.fliter_booking', function(){
    	var start_date = $('.start_date').val();
    	var end_date = $('.end_date').val();
    	var status = $('.status').val();
    	if(start_date != "")
    	{
    		if(end_date == '')
    		{
    			alert('Please select end date');
    			return false;
    		}
    	}
        
        if(end_date != '')
        {
        	if(start_date == '')
    		{
    			alert('Please select start date');
    			return false;
    		}
        }
       $('.center-block').css('display', 'block');
    	$.ajax({
	             url: "{{  url('/get-orders') }}",

	             type:"GET",
	             data:{'start_date': start_date, 'end_date':end_date, 'status':status},
	             dataType:"html",
	             success:function(data) {
	             	 if(data == 'no_data')
	             	 {
	             	 	toastr.error('No data found');
	             	 }
	             	 else
	             	 {
	             	 	$('.conts_section').html(data);
	             	 	$('.center-block').css('display', 'none');
	             	 }
	                 
	             },
	                    
	   });

    });


    $(document).on('click', '.pagination a', function(e){
    	e.preventDefault();
    	var url = $(this).attr('href').split('page=')[1];
    	var start_date = $('.start_date').val();
    	var end_date = $('.end_date').val();
    	var status = $('.status').val();
  		$('.center-block').css('display', 'block');
    	$.ajax({
	             url: "{{  url('/get-orders?page=') }}"+url,

	             type:"GET",
	             data:{'start_date': start_date, 'end_date':end_date, 'status':status},
	             dataType:"html",
	             success:function(data) {
	                 $('.conts_section').html(data);
	                 $('.center-block').css('display', 'none');
	             },
	                    
	   });
    });



  	

  });
</script>


@endsection