<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\RegisterController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });
Route::post('register', [RegisterController::class, 'register']);

Route::post('login', [RegisterController::class, 'login']);

Route::middleware('auth:sanctum')->group( function () {
//api 

 //carts
 Route::post('add-to-cart', [ApiController::class, 'addCart']);
 Route::post('cart-check', [ApiController::class, 'cartCheck']);
 


 //order
 Route::post('create-order', [ApiController::class, 'createOrder']);
 //Route::post('payment-response', [ApiController::class, 'paymentResponse']);

//payment
Route::post('payment-response', [ApiController::class, 'paymentSubmit']);

 //user calculation
 
 Route::get('/user-calculation', [ApiController::class, 'userCalculation']);
 
 Route::get('/pending-orders', [ApiController::class, 'PendingOrders']);
 
 
 //user profile
 Route::post('profile-update', [ApiController::class, 'profileUpdate']);
 Route::get('/user-profile', [ApiController::class, 'userProfile']);


 //logout
    Route::post('/logout', [RegisterController::class, 'logout']);

});
 

 Route::post('category-lists', [ApiController::class, 'categoryLists']);
 Route::post('product-lists', [ApiController::class, 'productLists']);
 Route::get('/product-details/{id}', [ApiController::class, 'productDetails']);
 Route::get('/news-lists', [ApiController::class, 'newsLists']);
 Route::get('/blog-lists', [ApiController::class, 'blogLists']);
 Route::get('/blog-details/{id}', [ApiController::class, 'blogDetails']);
 Route::get('/subcategory-lists', [ApiController::class, 'subCategoryLists']);
  //faq lists
 Route::get('/faq-lists', [ApiController::class, 'faqLists']);
 
  Route::post('filter-product-category', [ApiController::class, 'filterProductCategory']);
  
  Route::get('/payment-methods', [ApiController::class, 'paymentMethods']);
  
  //admin summary
 Route::get('/admin-summary', [ApiController::class, 'adminSummary']);
 
 //how it works
 Route::get('/how-it-works', [ApiController::class, 'howItWorks']);
 
 //privacy policy
 Route::get('/privacy-policy', [ApiController::class, 'privacyPolicy']);
 
 Route::get('/notices', [ApiController::class, 'notices']);
 
 //transactions
 Route::get('/get-transactions', [ApiController::class, 'getTransaction']);
 Route::post('wallet-transaction', [ApiController::class, 'walletTransaction']);
 Route::post('total-wallet-transaction', [ApiController::class, 'totalWalletTransaction']);
 
 Route::post('finy-balance', [ApiController::class, 'finyBalance']);
 
 Route::post('mr-payin', [ApiController::class, 'mrPayin']);
 
 Route::post('saeed-payin', [ApiController::class, 'saeedPayin']);
 
 //bcc
 Route::post('bcc-balance', [ApiController::class, 'bccBalance']);
 Route::post('bcc-wallet-transaction', [ApiController::class, 'BccwalletTransaction']);
 Route::post('bcc-total-wallet-transaction', [ApiController::class, 'BcctotalWalletTransaction']);
 
 
 //zohir vai payin
 
 Route::post('win-payin', [ApiController::class, 'winPayin']);
 
 Route::post('win-payout', [ApiController::class, 'winPayout']);
 
 