
<?php $__env->startSection('content'); ?>
 
 <div class="content-wrapper">
   <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Categories</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Simple Tables</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <section class="content">
    	<div class="container-fluid">
          <div class="row">
            <div class="col-md-12">
            	<div class="card">
              <div class="card-header">
                <h3 class="card-title">Category Lists</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
              	<input style="width: 300px; margin-bottom: 5px;" type="text" name="search_category" class="form-control search_category" placeholder="Search">
              	<div class="conts">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th style="text-align: center;">Image</th>
                      <th style="text-align: center;">Category Name</th>
                      <th style="text-align: center;">Action</th>
                    </tr>
                  </thead>
                  <tbody>
                  	<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr id="category_<?php echo e($category->id); ?>">
                      <td style="text-align: center;"><img style="width: 60px; height: 60px;" src="<?php echo e(URL::to('public/'.$category->image)); ?>"></td>
                      <td style="text-align: center;"><?php echo e($category->title); ?></td>
                      <td style="text-align: center;">
                      	<a href="<?php echo e(route('categories.edit',$category->id)); ?>" class="btn btn-info btn-sm">Edit</a>
                      	<a style="color: white; cursor: pointer;" class="btn btn-danger btn-sm delete-category" data-id="<?php echo e($category->id); ?>">Delete</a>
                      </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
                <?php echo e($categories->links()); ?>

               </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
            </div>
          </div>
    	</div>
    </section>
 </div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function(){

  	$.ajaxSetup({
	    headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	    }
	});

  	$(document).on('click', '.delete-category', function(e){
  		e.preventDefault();
  		if(confirm('Do you want to delete this?'))
  		{   
  			var id = $(this).data('id');
  			$('#category_'+id).remove();
	  		$.ajax({
	             url: "<?php echo e(url('/categories')); ?>/"+id,

	             type:"DELETE",
	             dataType:"json",
	             success:function(data) {
	                 toastr.success('Successfully Category Deleted')
	             },
	                    
	        });
  		}
  		

  	});

  	$(document).on('input', '.search_category', function(){
  		var search = $(this).val();
  		$.ajax({
	             url: "<?php echo e(url('/search-category')); ?>",

	             type:"GET",
	             data:{'title':search},
	             dataType:"html",
	             success:function(data) {
	                 $('.conts').html(data);
	             },
	                    
	        });
  	});
   
    $(document).on('click', '.pagination a', function(e){
    	e.preventDefault();
    	var url = $(this).attr('href').split('page=')[1];
    	var search = $('.search_category').val();
    	$.ajax({
	             url: "<?php echo e(url('/get-categories?page=')); ?>"+url,

	             type:"GET",
	             data:{'title': search},
	             dataType:"html",
	             success:function(data) {
	                 $('.conts').html(data);
	             },
	                    
	        });
    });

  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/upcjypes/public_html/crypto/wisefex/resources/views/category/index.blade.php ENDPATH**/ ?>