
<?php $__env->startSection('content'); ?>
 <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>General Form</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">General Form</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12">
          	 <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Edit Blog</h3>
              </div>

              <?php if(count($errors) > 0): ?>
               <div class = "alert alert-danger">
                  <ul>
                     <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
               </div>
            <?php endif; ?>
              <!-- /.card-header -->
              <!-- form start -->
              <form action="<?php echo e(route('blogs.update',$blog->id)); ?>" enctype="multipart/form-data" method="post">
              	<?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <div class="card-body">
                  
                  <div class="form-group">
                    <label for="title">Title</label>
                    <input type="text" name="title" class="form-control" id="title" placeholder="Title" required="" value="<?php echo e($blog->title); ?>">
                  </div> 


                  <div class="col-md-12">
                   	 <div class="form-group">
                   	 	<label for="description">Description</label>
	                     <textarea class="ckeditor form-control" name="description" required=""><?php echo $blog->description; ?></textarea>
                   	 </div>
                   </div>

                  <div class="row">
                  	<div class="col-md-6">
                  		<div class="form-group">
	                    <label for="image">Image</label>
	                    <div class="input-group">
	                      <div class="custom-file">
	                        <input type="file" name="image" class="custom-file-input"   accept="image/*"  onchange="readURL(this);">
	                        <label class="custom-file-label" for="image">Choose file</label>
	                      </div>
	                      <div class="input-group-append">
	                        <span class="input-group-text">Upload</span>
	                      </div>
	                    </div>
	                  </div>
                  	</div>

                  	<div class="col-md-6">
                  	  <div class="form-group">
                  	  	 <img src="<?php echo e(URL::to('public/'.$blog->image)); ?>" id="image" style="width: 60px; height: 60px; margin-top: 20px; border-radius: 50%;">
                  	  </div>
                  	</div>
                  </div>
                  
                </div>
                <!-- /.card-body -->

                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Update Blog</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
 </div>

 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
 <script>
    
    $.ajaxSetup({
	    headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	    }
	});

 	CKEDITOR.replace('description', {
        filebrowserUploadUrl: "<?php echo e(route('ckeditor.upload', ['_token' => csrf_token() ])); ?>",
        filebrowserUploadMethod: 'form'
    });

 	function readURL(input) {
      if (input.files && input.files[0]) {
      	$('#image').css('display', 'block');
          var reader = new FileReader();
          reader.onload = function (e) {
              $('#image')
                  .attr('src', e.target.result)
                  .width(60)
                  .height(60);
          };
          reader.readAsDataURL(input.files[0]);
      }
   }

 </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/upcjypes/public_html/crypto/wisefex/resources/views/blogs/edit.blade.php ENDPATH**/ ?>