<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;
use Auth;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
class ApiController extends Controller
{
    public function productLists(Request $request)
    {
    	try{
    	  $base_url = url('/')."/public";
    	  $products = DB::table('products')
    	              ->join('categories', 'products.category_id', 'categories.id')
                      ->join('super_categories', 'products.type_id', 'super_categories.id')
                      ->select('products.id', 'categories.title','super_categories.title as type', 'products.product_name', 'products.product_price', 'products.interest_rate',DB::raw("CONCAT('$base_url/', products.image) AS image"))
                      ->take($request->limit)
                      ->orderBy('products.id', 'DESC')
                      ->get();
          return response()->json(['status'=>true, 'data'=>$products]);
    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function categoryLists(Request $request)
    {
    	try{
    		$base_url = url('/')."/public";
    		$categories = DB::table('categories')
    		                ->select('categories.id','categories.title', DB::raw("CONCAT('$base_url/', categories.image) AS image"))
    		                ->take($request->limit)
    		                ->orderBy('id', 'DESC')
    		                ->get();
    	    return response()->json(['status'=>true, 'data'=>$categories]);
    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function productDetails($id)
    {
    	try{
    		$base_url = url('/')."/public";
    		$product = DB::table('products')
    					->join('categories', 'products.category_id', 'categories.id')
                        ->join('super_categories', 'products.type_id', 'super_categories.id')
                        ->select('products.id', 'categories.title','super_categories.title as type', 'products.product_name', 'products.interest_rate', 'products.product_price', 'products.product_unit', 'products.duration', 'products.duration_unit', 'products.address', 'products.description',DB::raw("CONCAT('$base_url/', products.image) AS image"))
    		            ->where('products.id',$id)
    		            ->orderBy('products.id', 'DESC')
    		            ->first();
    	   if(!$product)
    	   {
    	   	  return response()->json(['status'=>false, 'message'=>'No product found']);
    	   }

    	   return response()->json(['status'=>true, 'data'=>$product]);

    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function newsLists(Request $request)
    {
    	try{
    	  $base_url = url('/')."/public";
    	  $news = DB::table('news')
    	            ->select('news.id', 'news.source', 'news.title', DB::raw("CONCAT('$base_url/', news.image) AS image"), 'news.date_two', 'news.date', 'news.url as source_url')
    	            ->take(5)
    	            ->orderBy('news.id', 'DESC')
    	            ->get();
    	  return response()->json(['status'=>true, 'data'=>$news]);
    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function blogLists(Request $request)
    {
    	try{
    		$base_url = url('/')."/public";
    	    $blogs = DB::table('blogs')
    	            ->select('id', 'title', 'author', 'date_two', 'date', DB::raw("CONCAT('$base_url/', blogs.image) AS image"), 'blogs.date_two', 'blogs.date')
    	            ->take(5)
    	            ->orderBy('blogs.id','DESC')
    	            ->get();
    	    return response()->json(['status'=>true, 'data'=>$blogs]);
    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function blogDetails($id)
    {
    	try{
    		$base_url = url('/')."/public";
    	    $blog = DB::table('blogs')
    	            ->select('id', 'title', 'author', 'date_two', 'date', 'time', 'description', DB::raw("CONCAT('$base_url/', blogs.image) AS image"), 'blogs.date', 'blogs.date_two')
    	            ->where('id',$id)
    	            ->orderBy('blogs.id','DESC')
    	            ->first();
    	    if(!$blog)
    	    {
    	    	return response()->json(['status'=>false, 'message'=>'Blog is not found']);
    	    }
    	    return response()->json(['status'=>true, 'data'=>$blog]);
    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function addCart(Request $request)
    {
    	try{
	    	   $validator = Validator::make($request->all(), [
	             'product_id' => 'required|integer',
	             'cart_session_id' => 'required|string',
	             'cart_qty' => 'required|integer',
	          ]);
	          if($validator->fails()){
	            return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
	         }

	         $product = DB::table('products')->where('id',$request->product_id)->first();
	         if(!$product)
	         {
	         	return response()->json(['status'=>false, 'message'=>'No product found']);
	         }

	         $cart = DB::table('carts')->where('user_id',Auth::user()->id)->where('cart_session_id', $request->cart_session_id)->where('product_id',$request->product_id)->first();
             
             if($cart)
             {
             	 DB::table('carts')->where('id',$cart->id)->update(['cart_qty'=>$cart->cart_qty+$request->cart_qty]);

             	 $get_cart = DB::table('carts')->where('user_id', Auth::user()->id)->where('cart_session_id', $request->cart_session_id)->where('product_id',$request->product_id)->first();

             	 DB::table('carts')->where('id',$get_cart->id)->update(['cart_total'=>$product->product_price * $get_cart->cart_qty]);

             	 return response()->json(['status'=>true, 'message'=>'Cart updated successfully']);
             }

             $data = array();
             $data['user_id'] = Auth::user()->id;
             $data['cart_session_id'] = $request->cart_session_id;
             $data['product_id'] = $request->product_id;
             $data['cart_qty'] = $request->cart_qty;
             $data['cart_total'] = $product->product_price * $request->cart_qty;
             DB::table('carts')->insert($data);
             
             $odata = array();
             $odata['order_session_id'] = $request->cart_session_id;
             $odata['user_id'] = Auth::user()->id;
             $odata['date'] = date('Y-m-d');
             $odata['month'] = date('F');
             $odata['year'] = date('Y');
             $odata['status'] = 'pending';
             
             DB::table('orders')->insert($odata);

             return response()->json(['status'=>true, 'message'=>'Cart inserted successfully']);

    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function cartCheck(Request $request)
    {
    	try{
    	    $validator = Validator::make($request->all(), [
	             'product_id' => 'required|integer',
	             'cart_session_id' => 'required|string',
	             'cart_qty' => 'required|integer',
	          ]);
	          if($validator->fails()){
	            return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
	         }

	        $product = DB::table('products')->where('id',$request->product_id)->first();
	         if(!$product)
	         {
	         	return response()->json(['status'=>false, 'message'=>'No product found']);
	         }


	         return response()->json(['status'=>true, 'cart_total'=>$product->product_price * $request->cart_qty]);
	         
    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function subCategoryLists()
    {
    	try
    	{
    	  $sub_categories = DB::table('super_categories')->orderBy('id','ASC')->get();
    	  return response()->json(['status'=>true, 'data'=>$sub_categories]);
    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    
    public function paymentMethods()
    {
        try
        {
            $payment_methods = DB::table('payment_methods')->select('id', 'title', 'merchant_number')->where('is_selected', 'yes')->get();
            return response()->json(['status'=>true, 'data'=>$payment_methods]);
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    

    public function filterProductCategory(Request $request)
    {
    	try{
    	    $validator = Validator::make($request->all(), [
	             'category_id' => 'required|integer',
	             'sub_category_id' => 'required|integer',
	          ]);
	          if($validator->fails()){
	            return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
	         }
            $base_url = url('/')."/public";
            if($request->category_id == 0)
            {
                $products = DB::table('products')
                        ->select('products.id',  'products.product_name', 'products.interest_rate', 'products.product_price', 'products.product_unit', 'products.duration', 'products.duration_unit', 'products.address', 'products.description',DB::raw("CONCAT('$base_url/', products.image) AS image"))
	                      ->where('products.type_id', $request->sub_category_id)
	                      ->orderBy('id', 'DESC')
	                      ->get();
            }
            else
            {
                $products = DB::table('products')
                        ->select('products.id',  'products.product_name', 'products.interest_rate', 'products.product_price', 'products.product_unit', 'products.duration', 'products.duration_unit', 'products.address', 'products.description',DB::raw("CONCAT('$base_url/', products.image) AS image"))
	                      ->where('products.category_id',$request->category_id)
	                      ->where('products.type_id', $request->sub_category_id)
	                      ->orderBy('id', 'DESC')
	                      ->get();
            }
	        
            
            return response()->json(['status'=>true, 'data'=>$products]);
            	         
    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function createOrder(Request $request)
    {
    	try
    	{
           $validator = Validator::make($request->all(), [
	             'order_session_id' => 'required|string',
	             'gender' => 'required|string',
	             'address' => 'required',
	             'postal_code' => 'required|string',
	          ]);
	          if($validator->fails()){
	            return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
	         }

	         $odata = array();
	         $odata['gender'] = $request->gender;
	         $odata['nid'] = $request->nid;
	         $odata['address'] = $request->address;
	         $odata['contact_number'] = $request->contact_number;
	         DB::table('users')->where('id',Auth::user()->id)->update($odata);
             
             $data = array();
             $data['order_session_id'] = $request->order_session_id;
             $data['user_id'] = Auth::user()->id;
             $data['date'] = date('Y-m-d');
             $data['month'] = date('F');
             $data['year'] = date('Y');
             DB::table('orders')->insert($data);
             return response()->json(['status'=>true, 'message'=>'successfully order has been taken']);

    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function paymentResponse(Request $request)
    {
    	try
    	{   
    		$validator = Validator::make($request->all(), [
	             'order_session_id' => 'required|string',
	             'gender' => 'required|string',
	             'address' => 'required',
	             'postal_code' => 'required|string',
	          ]);
	          if($validator->fails()){
	            return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
	         }

    		DB::table('orders')->where('order_session_id',$request->order_session_id)->update(['status'=>'success']);

    		return response()->json(['status'=>true, 'message'=>'Order has been taken']);

    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function faqLists()
    {
        try{
           $faqs = DB::table('faqs')->orderBy('id', 'DESC')->get();
           return response()->json(['status'=>true, 'data'=>$faqs]); 
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function paymentSubmit(Request $request)
    {
        try
    	{   
    		$validator = Validator::make($request->all(), [
	             'order_session_id' => 'required|string',
                 'send_number'  => 'required|string', 
                 'transaction_id' => 'required|string',
                 'payment_type_id' => 'required|integer',
	          ]);
	          if($validator->fails()){
	            return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
	         }

    		DB::table('orders')->where('user_id',Auth::user()->id)->update(['status'=>'success', 'sender_no'=>$request->send_number, 'transaction_id'=>$request->transaction_id, 'payment_type_id'=>$request->payment_type_id]);

    		return response()->json(['status'=>true, 'message'=>'Payment taken successfully']);

    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function adminSummary()
    {
        try
        {
            $total_transaction = DB::table('carts')
                                   ->sum('carts.cart_total');
          $total_product = DB::table('products')->count();
          
          $total_users = DB::table('users')->where('role', 'user')->count();
          
          
          $success_transaction = DB::table('carts')
                                  ->join('orders', 'carts.cart_session_id', 'orders.order_session_id')
                                  ->where('orders.status', 'success')
                                  ->sum('carts.cart_total');
          //return response()->json($success_transaction);
          
          return response()->json(['status'=>true, 'total_transaction'=>$total_transaction, 'total_transaction_icon'=>url('/')."/"."public/uploads/icons/total_transaction.jpg", 'total_product'=>$total_product, 'product_icon'=>url('/')."/"."public/uploads/icons/products.png", 'total_users'=>$total_users, 'user_icon'=>url('/')."/"."public/uploads/icons/total_users.png", 'success_transaction'=>$success_transaction, 'success_transaction_icon'=>url('/')."/"."public/uploads/icons/success_transaction.jpg"]);
        
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function userCalculation()
    {
        try
        {  
          $total_fund = DB::table('carts')
                         ->join('orders', 'carts.cart_session_id', 'orders.order_session_id')
                         ->sum('carts.cart_total');
                         
            $total_earning = 0;
           $active_fund = DB::table('carts')
                            ->join('orders', 'carts.cart_session_id', 'orders.order_session_id')
                            ->select('carts.*')
                            ->where('carts.user_id', Auth::user()->id)
                            ->where('orders.status', 'success')
                            ->count();
                            
          $inactive_fund = DB::table('carts')
                            ->join('orders', 'carts.cart_session_id', 'orders.order_session_id')
                            ->select('carts.*')
                            ->where('carts.user_id', Auth::user()->id)
                            ->where('orders.status', 'pending')
                            ->count();
                            
           return response()->json(['status'=>true, 'total_fund'=>$total_fund, 'active_fund'=>$active_fund, 'inactive_fund'=>$inactive_fund, 'total_earning'=>$total_earning]);
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function PendingOrders()
    {
        try
        {
            $pending_orders = DB::table('orders')
                                ->join('carts', 'orders.order_session_id', 'carts.cart_session_id')
                                ->join('payment_methods', 'orders.payment_type_id', 'payment_methods.id')
                                ->select('orders.id', 'orders.sender_no', 'orders.transaction_id', 'payment_methods.title as payment_method', 'orders.date')
                                ->where('orders.user_id', Auth::user()->id)
                                ->where('orders.status', 'pending')
                                ->get();
            return response()->json(['status'=>true, 'data'=>$pending_orders]);   
            
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function profileUpdate(Request $request)
    {
        try
        {   
	         
            $data = array();
            $data['name'] = $request->name;
            $data['phone'] = $request->phone;
             if($request->file('image'))
            {   
                $featured_file = $request->file('image');
                $featured_image = time()."profile_".$featured_file->getClientOriginalName();
                    $featured_file->move(public_path().'/uploads/profile/', $featured_image);  
                    $path= 'public/uploads/profile/'.$featured_image; 
              $data['image'] = $path;
            }
           
           DB::table('users')->where('id',Auth::user()->id)->update($data);
           
           return response()->json(['status'=>true, 'message'=>'Profile updated successfully']);
            
            
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function userProfile()
    {
        try
        {   
            $base_url = url('/');
            $user = DB::table('users')->select('id', 'name', 'phone', DB::raw("CONCAT('$base_url/', users.image) AS image"))->where('id',Auth::user()->id)->first();
            if($user->image == null)
            {
                $image = "";
            }
            else
            {
                $image = $user->image;
            }
            $data = ['id'=>$user->id, 'name'=>$user->name, 'phone'=>$user->phone, 'image'=>$image];
            return response()->json(['status'=>true, 'data'=>$data]);
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function howItWorks()
    {
        try
        {
           $data = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.";
           return response()->json(['status'=>true, 'data'=>$data]);
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function privacyPolicy()
    {
        try
        {
           $data = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.";
           return response()->json(['status'=>true, 'data'=>$data]);
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function notices()
    {
        try
        {
            $data = DB::table('notices')->orderBy('id','DESC')->get();
            return response()->json(['status'=>true, 'data'=>$data]);
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function getTransaction(Request $request)
    {
    	try
    	{       
    	       $decimal = 1000000000000000000;    
    		  //  $url = "https://api.bscscan.com/api?module=account&action=tokentx&contractaddress=0xdf7c22b1358591f589ffafb122e13e6569a2a681&address=0x87faa964decf7fef0e74a89ba930f9651c5a81f3&page=$request->page&offset=100&startblock=0&endblock=999999999&sort=desc&apikey=172UK5PAKNXU531TJ5WWVT468UMJM3UDZM";
    		  
    		  $url = "https://api.bscscan.com/api?module=account&action=tokentx&address=0x87faa964decf7fef0e74a89ba930f9651c5a81f3&startblock=0&endblock=99999999&page=$request->page&offset=100&sort=desc&apikey=172UK5PAKNXU531TJ5WWVT468UMJM3UDZM";
    		    
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_URL,$url);
				$result=curl_exec($ch);
				curl_close($ch);
				$decode = json_decode($result, true);
				
				$data = array();
				foreach($decode['result'] as $row)
				{   
				    if($row['to'] == '0x87faa964decf7fef0e74a89ba930f9651c5a81f3')
				    {
				        $method = 'IN';
				    }
				    else
				    {
				        $method = 'OUT';
				    }
					$data[] = ['blockNumber'=>$row['blockNumber'], 'transaction_id'=>$row['hash'], 'wallet_address'=>$row['to'], 'value'=>$row['value']/$decimal, 'timeStamp'=>$row['timeStamp'], 'date'=>date('Y-m-d', $row['timeStamp']), 'currency'=>$row['tokenSymbol'], 'method'=>$method];
				}
				
				return response()->json(['status'=>true, 'data'=>$data]);
    	}
    	catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function paginate($items, $perPage = 2, $page = null, $options = [])
    {
        $page = $page ?: (Paginator::resolveCurrentPage() ?: 1);
        $items = $items instanceof Collection ? $items : Collection::make($items);
        return new LengthAwarePaginator($items->forPage($page, $perPage), $items->count(), $perPage, $page, $options);
    }

    public function walletTransaction(Request $request)
    {
    	try
    	{
    		$validator = Validator::make($request->all(), [
             'wallet_address' => 'required|string',
            ]);
            if($validator->fails()){
                return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
            }

            $validator = Validator::make($request->all(), [
             'wallet_address' => 'required|string',
            ]);
            if($validator->fails()){
                return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
            }

            $decimal = 1000000000000000000;    

            $convert_address = strtolower($request->wallet_address);

            $url2 = "https://api.bscscan.com/api?module=account&action=tokentx&contractaddress=0xdf7c22b1358591f589ffafb122e13e6569a2a681&address=$convert_address&page=1&offset=100&startblock=0&endblock=999999999&sort=desc&apikey=172UK5PAKNXU531TJ5WWVT468UMJM3UDZM";

            $ch2 = curl_init();
            curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch2, CURLOPT_URL,$url2);
            $result2=curl_exec($ch2);
            curl_close($ch2);
            //echo $result['results'];
            $decode2 = json_decode($result2, true);
            //return response()->json($decode2);

			//return response()->json(array_merge($get_data));
			$data = array();
			foreach($decode2['result'] as $row)
			{
              if($row['to'] == $convert_address)
              {
                  $method = 'IN';
              }
              else
              {
                  $method = 'OUT';
              }
				$data[] = ['blockNumber'=>$row['blockNumber'], 'transaction_id'=>$row['hash'], 'wallet_address'=>$row['to'], 'value'=>$row['value']/$decimal, 'timeStamp'=>$row['timeStamp'], 'date'=>date('Y-m-d', $row['timeStamp']), 'method'=>$method];
			}
			//return response()->json(['status'=>true, 'data'=>$data]);
			if(count($data) > 0)
			{
			    return response()->json(['status'=>true, 'message'=>'Data found', 'data'=>$data]);
			}
			return response()->json(['status'=>false, 'message'=>'No data found', 'data'=>$data]);


    	}
    	catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function totalWalletTransaction(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
             'wallet_address' => 'required|string',
            ]);
            if($validator->fails()){
                return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
            }
            
            $decimal = 1000000000000000000;    
		    $url = 'https://api.bscscan.com/api?module=token&action=tokenholderlist&contractaddress=0xdf7c22b1358591f589ffafb122e13e6569a2a681&page=1&offset=100&apikey=172UK5PAKNXU531TJ5WWVT468UMJM3UDZM';
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_URL,$url);
			$result=curl_exec($ch);
			curl_close($ch);
			//echo $result['results'];
			$decode = json_decode($result, true);
			$get_data = array_merge(array_filter($decode['result'], function($result) use ($request) {
					   return $result['TokenHolderAddress'] == $request->wallet_address;
					}));
			
			return response()->json($get_data);
        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
    public function finyBalance(Request $request)
    {
        try
        {   
            $validator = Validator::make($request->all(), [
             'wallet_address' => 'required|string',
            ]);
            if($validator->fails()){
                return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
            }

            $decimal = 1000000000000000000; 
            

            $url2 = "https://api.bscscan.com/api?module=token&action=tokenholderlist&contractaddress=0xdf7c22b1358591f589ffafb122e13e6569a2a681&page=1&offset=100&apikey=172UK5PAKNXU531TJ5WWVT468UMJM3UDZM";

            $ch2 = curl_init();
            curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch2, CURLOPT_URL,$url2);
            $result2=curl_exec($ch2);
            curl_close($ch2);
            //echo $result['results'];
            $decode2 = json_decode($result2, true);
           
            $get_data = array_merge(array_filter($decode2['result'], function($result) use ($request) {
                           return $result['TokenHolderAddress'] == strtolower($request->wallet_address);
                        }));
            if(count($get_data) > 0)
            {
                return response()->json(['status'=>true, 'message'=>'Data found', 'balance'=>$get_data[0]['TokenHolderQuantity']/$decimal]);
            }
            else
            {
                return response()->json(['status'=>false, 'message'=>'No data found', 'balance'=>0]);
            }
            

        }
        catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
    
}
