<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
class BlogController extends Controller
{  

     public function __construct()
    {
        $this->middleware('auth_check');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
          $blogs = DB::table('blogs')->orderBy('id','DESC')->paginate(10);
          return view('blogs.index', compact('blogs'));
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('blogs.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            $request->validate([
                   'title' => 'required|string|unique:blogs',
                   'image' => 'required',
            ]);
                $file = $request->file('image');
                $name = time().$file->getClientOriginalName();
                $file->move(public_path().'/uploads/blogs/', $name);  
                $path= 'uploads/blogs/'.$name; 
                $data = array();
                $data['title'] = $request->title;
                $data['author'] = Auth::user()->name;
                $data['date'] = date('Y-m-d');
                $data['date_two'] = date('d F Y');
                $data['month'] = date('F');
                $data['year'] = date('Y');
                $data['time'] = date('H:i:s A');
                $data['description'] = $request->description;
                $data['image'] = $path;
                DB::table('blogs')->insert($data);
                $notification=array(
                         'messege'=>'Successfully Blog Added',
                         'alert-type'=>'success'
                        );
                return redirect()->back()->with($notification);

        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try{
            $blog = DB::table('blogs')->where('id',$id)->first();
            return view('blogs.edit', compact('blog'));
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{  
              $request->validate([
                   'title' => 'required|string|unique:blogs,title,'.$id,
             ]);
              $blog = DB::table('blogs')->where('id',$id)->first();
              $data = array();
              if($request->file('image'))
              {
                    $file = $request->file('image');
                    $name = time().$file->getClientOriginalName();
                    $file->move(public_path().'/uploads/blogs/', $name);  
                    $path= 'uploads/blogs/'.$name; 
                    $data['image'] = $path;
                    unlink(public_path($blog->image));
              }
              else
              {
                $data['image'] = $blog->image;
              }
                $data['title'] = $request->title;
                $data['author'] = Auth::user()->name;
                $data['date'] = date('Y-m-d');
                $data['date_two'] = date('d F Y');
                $data['month'] = date('F');
                $data['year'] = date('Y');
                $data['time'] = date('H:i:s A');
                $data['description'] = $request->description;
                DB::table('blogs')->where('id',$id)->update($data);
                $notification=array(
                         'messege'=>'Successfully Blog Updated',
                         'alert-type'=>'success'
                        );
                return redirect()->back()->with($notification);
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
          $blog = DB::table('blogs')->where('id',$id)->first();
          unlink(public_path($blog->image));
          DB::table('blogs')->where('id',$id)->delete();
          $notification=array(
                         'messege'=>'Successfully Blog Deleted',
                         'alert-type'=>'success'
                        );
          return redirect()->back()->with($notification);

        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function upload(Request $request)
    {  
       try{
          if($request->hasFile('upload')) {
            $originName = $request->file('upload')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('upload')->getClientOriginalExtension();
            $fileName = $fileName.'_'.time().'.'.$extension;
        
            $request->file('upload')->move(public_path('images'), $fileName);
   
            $CKEditorFuncNum = $request->input('CKEditorFuncNum');
            $url = asset('images/'.$fileName); 
            $msg = 'Image uploaded successfully'; 
            $response = "<script>window.parent.CKEDITOR.tools.callFunction($CKEditorFuncNum, '$url', '$msg')</script>";
               
            @header('Content-type: text/html; charset=utf-8'); 
            echo $response;
        }
       }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
        
    }
}
