<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;

class ProductController extends Controller
{   
   public function __construct()
    {
        $this->middleware('auth_check');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
          $types = DB::table('super_categories')->orderBy('id','DESC')->get();
          $categories = DB::table('categories')->orderBy('id','DESC')->get();
          $products = DB::table('products')
                        ->join('categories', 'products.category_id', 'categories.id')
                        ->join('super_categories', 'products.type_id', 'super_categories.id')
                        ->select('products.*', 'categories.title', 'super_categories.title as type')
                        ->orderBy('products.id','DESC')
                        ->paginate(10);
          return view('product.index', compact('products', 'types', 'categories'));
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {  
          try{
            $types = DB::table('super_categories')->orderBy('id','DESC')->get();
            $categories = DB::table('categories')->orderBy('id','DESC')->get();
            return view('product.create', compact('types', 'categories'));
          }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }  
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            $request->validate([
                   'product_name' => 'required|string|unique:products',
                   'type_id' => 'required|integer',
                   'category_id' => 'required|integer',
                   'description' => 'required',
                   'image' => 'required',
            ]);

            $data = array();
            $file = $request->file('image');
            $name = time().$file->getClientOriginalName();
            $file->move(public_path().'/uploads/products/', $name);  
            $path= 'uploads/products/'.$name;
            $data['category_id'] = $request->category_id;
            $data['type_id'] = $request->type_id;
            $data['interest_rate'] = $request->interest_rate;
            $data['product_name'] = $request->product_name;
            $data['product_price'] = $request->product_price;
            $data['product_unit'] = $request->product_unit;
            $data['duration'] = $request->duration;
            $data['duration_unit'] = $request->duration_unit;
            $data['address'] = $request->address;
            $data['description'] = strip_tags($request->description);
            $data['image'] = $path;
            DB::table('products')->insert($data);
            $notification=array(
                         'messege'=>'Successfully Product Added',
                         'alert-type'=>'success'
                        );
                return redirect()->back()->with($notification);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try{
          $types = DB::table('super_categories')->orderBy('id','DESC')->get();
          $categories = DB::table('categories')->orderBy('id','DESC')->get();
          $product = DB::table('products')->where('id',$id)->first();
          return view('product.edit', compact('product', 'types','categories'));  
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            $request->validate([
                   'product_name' => 'required|string|unique:products,product_name,'.$id,
                   'type_id' => 'required|integer',
                   'category_id' => 'required|integer',
                   'description' => 'required',
            ]);
            $product = DB::table('products')->where('id',$id)->first();
            $data = array();
            if($request->file('image'))
            {
                $file = $request->file('image');
                $name = time().$file->getClientOriginalName();
                $file->move(public_path().'/uploads/products/', $name);  
                $path= 'uploads/products/'.$name;
                unlink(public_path($product->image));
                $data['image'] = $path;
            }
            else
            {
                $data['image'] = $product->image;
            }
            $data['category_id'] = $request->category_id;
            $data['type_id'] = $request->type_id;
            $data['interest_rate'] = $request->interest_rate;
            $data['product_name'] = $request->product_name;
            $data['product_price'] = $request->product_price;
            $data['product_unit'] = $request->product_unit;
            $data['duration'] = $request->duration;
            $data['duration_unit'] = $request->duration_unit;
            $data['address'] = $request->address;
            $data['description'] = strip_tags($request->description);
            DB::table('products')->where('id',$id)->update($data);
            $notification=array(
                         'messege'=>'Successfully Product Updated',
                         'alert-type'=>'success'
                        );
                return redirect()->back()->with($notification);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
          $product = DB::table('products')->where('id',$id)->first();
          unlink(public_path($product->image));  
          DB::table('products')->where('id',$id)->delete();
          return response()->json('deleted');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }

    public function searchProduct(Request $request)
    {
        try{
          if(!empty($request->product_name) && $request->category_id != 'all_category' && $request->type_id != 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.product_name', 'like', "%$request->product_name%")
                           ->where('products.category_id', $request->category_id)
                           ->where('products.type_id', $request->type_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);   
          }
          elseif(!empty($request->product_name) && $request->category_id != 'all_category' && $request->type_id == 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.product_name', 'like', "%$request->product_name%")
                           ->where('products.category_id', $request->category_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);  
          }
          elseif(!empty($request->product_name) && $request->category_id == 'all_category' && $request->type_id != 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.product_name', 'like', "%$request->product_name%")
                           ->where('products.type_id', $request->type_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10); 
          }
          elseif(empty($request->product_name) && $request->category_id != 'all_category' && $request->type_id != 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.category_id', $request->category_id)
                           ->where('products.type_id', $request->type_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);
          }
          elseif(!empty($request->product_name) && $request->category_id == 'all_category' && $request->type_id == 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.product_name', 'like', "%$request->product_name%")
                           ->orderBy('products.id','DESC')
                           ->paginate(10);
          }
          elseif(empty($request->product_name) && $request->category_id != 'all_category' && $request->type_id == 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.category_id', $request->category_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);
          }
          elseif(empty($request->product_name) && $request->category_id == 'all_category' && $request->type_id != 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.type_id', $request->type_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);
          }
          else
          {
             $products = DB::table('products')
                        ->join('categories', 'products.category_id', 'categories.id')
                        ->join('super_categories', 'products.type_id', 'super_categories.id')
                        ->select('products.*', 'categories.title', 'super_categories.title as type')
                        ->orderBy('products.id','DESC')
                        ->paginate(10);
          }
          if(count($products) > 0)
          {
             return view('product.paginate', compact('products'));
          }
          else
          {
             echo "no_data";
          }
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }

    public function productPaginate(Request $request)
    {
        try{
          if(!empty($request->product_name) && $request->category_id != 'all_category' && $request->type_id != 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.product_name', 'like', "%$request->product_name%")
                           ->where('products.category_id', $request->category_id)
                           ->where('products.type_id', $request->type_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);   
          }
          elseif(!empty($request->product_name) && $request->category_id != 'all_category' && $request->type_id == 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.product_name', 'like', "%$request->product_name%")
                           ->where('products.category_id', $request->category_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);  
          }
          elseif(!empty($request->product_name) && $request->category_id == 'all_category' && $request->type_id != 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.product_name', 'like', "%$request->product_name%")
                           ->where('products.type_id', $request->type_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10); 
          }
          elseif(empty($request->product_name) && $request->category_id != 'all_category' && $request->type_id != 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.category_id', $request->category_id)
                           ->where('products.type_id', $request->type_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);
          }
          elseif(!empty($request->product_name) && $request->category_id == 'all_category' && $request->type_id == 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.product_name', 'like', "%$request->product_name%")
                           ->orderBy('products.id','DESC')
                           ->paginate(10);
          }
          elseif(empty($request->product_name) && $request->category_id != 'all_category' && $request->type_id == 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.category_id', $request->category_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);
          }
          elseif(empty($request->product_name) && $request->category_id == 'all_category' && $request->type_id != 'all_type')
          {
              $products = DB::table('products')
                           ->join('categories', 'products.category_id', 'categories.id')
                           ->join('super_categories', 'products.type_id', 'super_categories.id')
                           ->select('products.*', 'categories.title', 'super_categories.title as type') 
                           ->where('products.type_id', $request->type_id)
                           ->orderBy('products.id','DESC')
                           ->paginate(10);
          }
          else
          {
             $products = DB::table('products')
                        ->join('categories', 'products.category_id', 'categories.id')
                        ->join('super_categories', 'products.type_id', 'super_categories.id')
                        ->select('products.*', 'categories.title', 'super_categories.title as type')
                        ->orderBy('products.id','DESC')
                        ->paginate(10);
          }
          return view('product.paginate', compact('products'));   
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }
}
