@extends('admin_master')
@section('content')
 
 <div class="content-wrapper">
   <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Posts</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Products</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <section class="content">
    	<div class="container-fluid">
          <div class="row">
            <div class="col-md-12">
            	<div class="card">
              <div class="card-header">
                <h3 class="card-title">Product Lists</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
               <div class="row">
               	 <div class="col-md-3">
               	 	<input style="width: 300px;" type="text" name="search_product" class="form-control search_product" placeholder="Search">
               	 </div>
               	 
               	 <div class="col-md-3">
               	 	<select style="width: 300px; padding-top: 2px!important;" class="form-control category_id select2" name="category_id">
               	 		<option value="all_category" selected="">All Category</option>
               	 	   @foreach($categories as $category)
               	 	     <option value="{{$category->id}}">{{$category->title}}</option>
               	 	   @endforeach
               	 	</select>
               	 </div>


               	 <div class="col-md-3">
               	 	<select style="width: 300px; padding-top: 2px!important;" class="form-control type_id select2" name="type_id">
               	 		<option value="all_type" selected="">All Type</option>
               	 	   @foreach($types as $type)
               	 	     <option value="{{$type->id}}">{{$type->title}}</option>
               	 	   @endforeach
               	 	</select>
               	 </div>

                 
               </div>
              	<img style="display: none;" class="center-block" src="{{asset('public/back/loader.gif')}}">
              	<div class="conts" style="margin-top: 10px;">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th style="text-align: center;">Image</th>
                      <th style="text-align: center;">Product Name</th>
                      <th style="text-align: center;">Category</th>
                      <th style="text-align: center;">Type</th>
                      <th style="text-align: center;">Action</th>
                    </tr>
                  </thead>
                  <tbody>
                  	@foreach($products as $product)
                    <tr id="product_{{$product->id}}">
                      <td style="text-align: center;"><img style="width: 60px; height: 60px;" src="{{URL::to('public/'.$product->image)}}"></td>
                      <td style="text-align: center;">{{$product->product_name}}</td>
                      <td style="text-align: center;">{{$product->title}}</td>
                      <td style="text-align: center;">{{$product->type}}</td>
                      <td style="text-align: center;">
                      	<a href="{{route('products.edit',$product->id)}}" class="btn btn-info btn-sm">Edit</a>
                      	<a style="color: white; cursor: pointer;" class="btn btn-danger btn-sm delete-product" data-id="{{$product->id}}">Delete</a>
                      </td>
                    </tr>
                    @endforeach
                  </tbody>
                </table>
                {{$products->links()}}
               </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
            </div>
          </div>
    	</div>
    </section>
 </div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function(){

  	$.ajaxSetup({
	    headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	    }
	});

  	$(document).on('click', '.delete-product', function(e){
  		e.preventDefault();
  		if(confirm('Do you want to delete this?'))
  		{   
  			var id = $(this).data('id');
  			$('#product_'+id).remove();
	  		$.ajax({
	             url: "{{  url('/products') }}/"+id,

	             type:"DELETE",
	             dataType:"json",
	             success:function(data) {
	                 toastr.success('Successfully Product Deleted')
	             },
	                    
	        });
  		}
  		

  	});

  	$(document).on('input', '.search_product', function(){
  		var search = $(this).val();
  		var category_id = $('.category_id').val();
  		var type_id = $('.type_id').val();
  		$('.center-block').css('display', 'block');
  		$.ajax({
	             url: "{{  url('/search-product') }}",

	             type:"GET",
	             data:{'product_name':search, 'category_id':category_id, 'type_id':type_id},
	             dataType:"html",
	             success:function(data) {
	             	if(data == 'no_data')
	             	{
	             		toastr.error('No data found');
	                 
	             	}
	             	else
	             	{
	             	  $('.conts').html(data);
	             	  $('.center-block').css('display', 'none');
	             	}
	             	
	             },
	                    
	        });
  	});

  	$(document).on('change', '.category_id', function(){
  		 var search = $('.search_product').val();
  		var category_id = $(this).val();
  		var type_id = $('.type_id').val();
  		$('.center-block').css('display', 'block');
  		$.ajax({
	             url: "{{  url('/search-product') }}",

	             type:"GET",
	             data:{'product_name':search, 'category_id':category_id, 'type_id':type_id},
	             dataType:"html",
	             success:function(data) {
	                 if(data == 'no_data')
	             	{
	             		toastr.error('No data found');
	                 
	             	}
	             	else
	             	{
	             	  $('.conts').html(data);
	             	  $('.center-block').css('display', 'none');
	             	}
	             },
	                    
	        });
  	});

  	$(document).on('change', '.type_id', function(){
  		 var search = $('.search_product').val();
  		var category_id = $('.category_id').val();
  		var type_id = $(this).val();
  		$('.center-block').css('display', 'block');
  		$.ajax({
	             url: "{{  url('/search-product') }}",

	             type:"GET",
	             data:{'product_name':search, 'category_id':category_id, 'type_id':type_id},
	             dataType:"html",
	             success:function(data) {
	                 if(data == 'no_data')
	             	{
	             		toastr.error('No data found');
	                 
	             	}
	             	else
	             	{
	             	  $('.conts').html(data);
	             	  $('.center-block').css('display', 'none');
	             	}
	             },
	                    
	        });
  	});
   
    $(document).on('click', '.pagination a', function(e){
    	e.preventDefault();
    	var url = $(this).attr('href').split('page=')[1];
    	var search = $('.search_product').val();
    	var category_id = $('.category_id').val();
  		var type_id = $('.type_id').val();
  		$('.center-block').css('display', 'block');
    	$.ajax({
	             url: "{{  url('/get-products?page=') }}"+url,

	             type:"GET",
	             data:{'product_name': search, 'category_id':category_id, 'type_id':type_id},
	             dataType:"html",
	             success:function(data) {
	                 $('.conts').html(data);
	                 $('.center-block').css('display', 'none');
	             },
	                    
	        });
    });

  });
</script>
@endsection